<p data-nodeid="24704" class="">在上一课时，我们介绍了“缓冲”，这一课时我将介绍“缓冲”的孪生兄弟“缓存”。</p>
<p data-nodeid="24705">和缓冲类似，缓存可能是软件中使用最多的优化技术了，比如：在最核心的 CPU 中，就存在着多级缓存；为了消除内存和存储之间的差异，各种类似 Redis 的缓存框架更是层出不穷。</p>
<p data-nodeid="24706">缓存的优化效果是非常好的，它既可以让原本载入非常缓慢的页面，瞬间秒开，也能让本是压力山大的数据库，瞬间清闲下来。</p>
<p data-nodeid="24707"><strong data-nodeid="24859">缓存</strong>，<strong data-nodeid="24860">本质</strong>上是为了协调两个速度差异非常大的组件，如下图所示，通过加入一个中间层，将常用的数据存放在相对高速的设备中。</p>
<p data-nodeid="24708"><img src="https://s0.lgstatic.com/i/image/M00/3C/6B/CgqCHl8nuCKAad7oAAAk6v90xvo900.png" alt="Drawing 1.png" data-nodeid="24863"></p>
<p data-nodeid="24709">在我们平常的应用开发中，根据缓存所处的物理位置，一般分为<strong data-nodeid="24873">进程内</strong>缓存和<strong data-nodeid="24874">进程外</strong>缓存。</p>
<p data-nodeid="24710">本课时我们主要聚焦在进程内缓存上，在 Java 中，进程内缓存，就是我们常说的堆内缓存。Spring 的默认实现里，就包含 Ehcache、JCache、Caffeine、Guava Cache 等。</p>
<h3 data-nodeid="24711">Guava 的 LoadingCache</h3>
<p data-nodeid="24712">Guava 是一个常用的工具包，其中的 <strong data-nodeid="24886">LoadingCache</strong>（下面简称 LC），是非常好用的<strong data-nodeid="24887">堆内缓存工具</strong>。通过学习 LC 的结构，即可了解堆内缓存设计的一般思路。</p>
<p data-nodeid="24713">缓存一般是比较昂贵的组件，容量是有限制的，设置得过小，或者过大，都会影响缓存性能：</p>
<ul data-nodeid="24714">
<li data-nodeid="24715">
<p data-nodeid="24716">缓存空间过小，就会造成高命中率的元素被频繁移出，失去了缓存的意义；</p>
</li>
<li data-nodeid="24717">
<p data-nodeid="24718">缓存空间过大，不仅浪费宝贵的缓存资源，还会对垃圾回收产生一定的压力。</p>
</li>
</ul>
<p data-nodeid="24719">通过 Maven，即可引入 guava 的 jar 包：</p>
<pre class="lang-dart" data-nodeid="24720"><code data-language="dart">&lt;dependency&gt; 
 &nbsp; &nbsp;&lt;groupId&gt;com.google.guava&lt;/groupId&gt; 
 &nbsp; &nbsp;&lt;artifactId&gt;guava&lt;/artifactId&gt; 
 &nbsp; &nbsp;&lt;version&gt;<span class="hljs-number">29.0</span>-jre&lt;/version&gt; 
&lt;/dependency&gt;
</code></pre>
<p data-nodeid="24721">下面介绍一下 LC 的常用操作：</p>
<p data-nodeid="24722"><img src="https://s0.lgstatic.com/i/image/M00/3C/60/Ciqc1F8nuDmAJcstAABnG73x05M360.png" alt="Drawing 3.png" data-nodeid="24895"></p>
<h4 data-nodeid="24723">1.缓存初始化</h4>
<p data-nodeid="24724">首先，我们可以通过下面的参数设置一下 LC 的大小。一般，我们只需给缓存提供一个上限。</p>
<ul data-nodeid="24725">
<li data-nodeid="24726">
<p data-nodeid="24727"><strong data-nodeid="24902">maximumSize</strong> 这个参数用来设置缓存池的最大容量，达到此容量将会清理其他元素；</p>
</li>
<li data-nodeid="24728">
<p data-nodeid="24729"><strong data-nodeid="24907">initialCapacity</strong> 默认值是 16，表示初始化大小；</p>
</li>
<li data-nodeid="24730">
<p data-nodeid="24731"><strong data-nodeid="24912">concurrencyLevel</strong> 默认值是 4，和初始化大小配合使用，表示会将缓存的内存划分成 4 个 segment，用来支持高并发的存取。</p>
</li>
</ul>
<h4 data-nodeid="24732">2.缓存操作</h4>
<p data-nodeid="24733">那么缓存数据是怎么放进去的呢？有两种模式：</p>
<ul data-nodeid="24734">
<li data-nodeid="24735">
<p data-nodeid="24736">使用 put 方法手动处理，比如，我从数据库里查询出一个 User 对象，然后手动调用代码进去；</p>
</li>
<li data-nodeid="24737">
<p data-nodeid="24738">主动触发（ 这也是 Loading 这个词的由来），通过提供一个 CacheLoader 的实现，就可以在用到这个对象的时候，进行延迟加载。</p>
</li>
</ul>
<pre class="lang-java" data-nodeid="24739"><code data-language="java"><span class="hljs-function"><span class="hljs-keyword">public</span> <span class="hljs-keyword">static</span> <span class="hljs-keyword">void</span> <span class="hljs-title">main</span><span class="hljs-params">(String[] args)</span> </span>{ 
 &nbsp; &nbsp;LoadingCache&lt;String, String&gt; lc = CacheBuilder 
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;  .newBuilder() 
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;  .build(<span class="hljs-keyword">new</span> CacheLoader&lt;String, String&gt;() { 
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-meta">@Override</span> 
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-function"><span class="hljs-keyword">public</span> String <span class="hljs-title">load</span><span class="hljs-params">(String key)</span> <span class="hljs-keyword">throws</span> Exception </span>{ 
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-keyword">return</span> slowMethod(key); 
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;  } 
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;  }); 
} 
 
<span class="hljs-function"><span class="hljs-keyword">static</span> String <span class="hljs-title">slowMethod</span><span class="hljs-params">(String key)</span> <span class="hljs-keyword">throws</span> Exception </span>{ 
 &nbsp; &nbsp;Thread.sleep(<span class="hljs-number">1000</span>); 
 &nbsp; &nbsp;<span class="hljs-keyword">return</span> key + <span class="hljs-string">".result"</span>; 
}
</code></pre>
<p data-nodeid="24740">上面是主动触发的示例代码，你可以使用 <strong data-nodeid="24930">get</strong> 方法<strong data-nodeid="24931">获取</strong>缓存的值。比如，当我们执行 lc.get("a") 时，第一次会比较缓慢，因为它需要到数据源进行获取；第二次就瞬间返回了，也就是缓存命中了。具体时序可以参见下面这张图。</p>
<p data-nodeid="24741"><img src="https://s0.lgstatic.com/i/image/M00/3C/6C/CgqCHl8nuFGACX8vAABYHt8o1wc201.png" alt="Drawing 5.png" data-nodeid="24934"></p>
<p data-nodeid="24742">除了靠 LC 自带的回收策略，我们也可以<strong data-nodeid="24944">手动删除</strong>某一个元素，这就是 <strong data-nodeid="24945">invalidate</strong> 方法。当然，数据的这些删除操作，也是可以监听到的，只需要设置一个监听器就可以了，代码如下：</p>
<pre class="lang-java" data-nodeid="24743"><code data-language="java">.removalListener(notification -&gt; System.out.println(notification))
</code></pre>
<h4 data-nodeid="24744">3.回收策略</h4>
<p data-nodeid="24745">缓存的大小是有限的，满了以后怎么办？这就需要回收策略进行处理，接下来我会向你介绍三种回收策略。</p>
<p data-nodeid="24746">（1）第一种回收策略<strong data-nodeid="24952">基于容量</strong></p>
<p data-nodeid="24747">这个比较好理解，也就是说如果缓存满了，就会按照 LRU 算法来移除其他元素。</p>
<p data-nodeid="24748">（2）第二种回收策略<strong data-nodeid="24958">基于时间</strong></p>
<ul data-nodeid="24749">
<li data-nodeid="24750">
<p data-nodeid="24751">一种方式是，通过 expireAfterWrite 方法设置数据写入以后在某个时间失效；</p>
</li>
<li data-nodeid="24752">
<p data-nodeid="24753">另一种是，通过 expireAfterAccess 方法设置最早访问的元素，并优先将其删除。</p>
</li>
</ul>
<p data-nodeid="24754">（3）第三种回收策略<strong data-nodeid="24965">基于 JVM 的垃圾回收</strong></p>
<p data-nodeid="24755">我们都知道对象的引用有强、软、弱、虚等四个级别，通过 weakKeys 等函数即可设置相应的引用级别。当 JVM 垃圾回收的时候，会主动清理这些数据。</p>
<p data-nodeid="24756">关于第三种回收策略，有一个<strong data-nodeid="24971">高频面试题：如果你同时设置了 weakKeys 和 weakValues函数，LC 会有什么反应？</strong></p>
<p data-nodeid="24757">答案：如果同时设置了这两个函数，它代表的意思是，当没有任何强引用，与 key <strong data-nodeid="24977">或者</strong> value 有关系时，就删掉整个缓存项。这两个函数经常被误解。</p>
<h4 data-nodeid="24758">4.缓存造成内存故障</h4>
<p data-nodeid="24759">LC 可以通过 recordStats 函数，对缓存加载和命中率等情况进行监控。</p>
<p data-nodeid="24760"><strong data-nodeid="24983">值得注意的是：LC 是基于数据条数而不是基于缓存物理大小的，所以如果你缓存的对象特别大，就会造成不可预料的内存占用。</strong></p>
<p data-nodeid="24761">围绕这点，我分享一个由于不正确使用缓存导致的常见内存故障。</p>
<p data-nodeid="24762">大多数堆内缓存，都会将对象的引用设置成弱引用或软引用，这样内存不足时，可以优先释放缓存占用的空间，给其他对象腾出地方。这种做法的初衷是好的，但容易出现问题。</p>
<p data-nodeid="24763">当你的缓存使用非常频繁，数据量又比较大的情况下，缓存会占用大量内存，如果此时发生了垃圾回收（GC），缓存空间会被释放掉，但又被迅速占满，从而会再次触发垃圾回收。如此往返，GC 线程会耗费大量的 CPU 资源，缓存也就失去了它的意义。</p>
<p data-nodeid="24764">所以在这种情况下，把缓存设置的小一些，减轻 JVM 的负担，是一个很好的方法。</p>
<h3 data-nodeid="24765">缓存算法</h3>
<h4 data-nodeid="24766">1.算法介绍</h4>
<p data-nodeid="24767">堆内缓存最常用的有 FIFO、LRU、LFU 这三种算法。</p>
<ul data-nodeid="24768">
<li data-nodeid="24769">
<p data-nodeid="24770"><strong data-nodeid="24994">FIFO</strong></p>
</li>
</ul>
<p data-nodeid="24771">这是一种先进先出的模式。如果缓存容量满了，将会<strong data-nodeid="25000">移除最先加入的元素</strong>。这种缓存实现方式简单，但符合先进先出的队列模式场景的功能不多，应用场景较少。</p>
<ul data-nodeid="24772">
<li data-nodeid="24773">
<p data-nodeid="24774"><strong data-nodeid="25004">LRU</strong></p>
</li>
</ul>
<p data-nodeid="24775">LRU 是最近最少使用的意思，当缓存容量达到上限，它会<strong data-nodeid="25014">优先移除那些最久未被使用的数据</strong>，LRU是目前<strong data-nodeid="25015">最常用</strong>的缓存算法，稍后我们会使用 Java 的 API 简单实现一个。</p>
<ul data-nodeid="24776">
<li data-nodeid="24777">
<p data-nodeid="24778"><strong data-nodeid="25019">LFU</strong></p>
</li>
</ul>
<p data-nodeid="24779">LFU 是最近最不常用的意思。相对于 LRU 的时间维度，LFU 增加了访问次数的维度。如果缓存满的时候，将<strong data-nodeid="25029">优先移除访问次数最少的元素</strong>；而当有多个访问次数相同的元素时，则<strong data-nodeid="25030">优先移除最久未被使用的元素</strong>。</p>
<h4 data-nodeid="24780">2.实现一个 LRU 算法</h4>
<p data-nodeid="24781">Java 里面实现 LRU 算法可以有多种方式，其中最常用的就是 <strong data-nodeid="25042">LinkedHashMap，<strong data-nodeid="25041">这也是一个需要你注意的</strong>面试高频考点</strong>。</p>
<p data-nodeid="24782">首先，我们来看一下 LinkedHashMap 的构造方法：</p>
<pre class="lang-java" data-nodeid="24783"><code data-language="java"><span class="hljs-function"><span class="hljs-keyword">public</span> <span class="hljs-title">LinkedHashMap</span><span class="hljs-params">(<span class="hljs-keyword">int</span> initialCapacity, 
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-keyword">float</span> loadFactor, 
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-keyword">boolean</span> accessOrder)</span>
</span></code></pre>
<p data-nodeid="24784">accessOrder 参数是实现 LRU 的关键。当 accessOrder 的值为 true 时，将按照对象的访问顺序排序；当 accessOrder 的值为 false 时，将按照对象的插入顺序排序。我们上面提到过，按照访问顺序排序，其实就是 LRU。</p>
<p data-nodeid="24785"><img src="https://s0.lgstatic.com/i/image/M00/3C/6C/CgqCHl8nuJeAQCW4AABgBDKI74g880.png" alt="Drawing 7.png" data-nodeid="25047"></p>
<p data-nodeid="24786">如上图，按照缓存的一般设计方式，和 LC 类似，当你向 LinkedHashMap 中添加新对象的时候，就会调用 removeEldestEntry 方法。这个方法默认返回 false，表示永不过期。我们只需要覆盖这个方法，当超出容量的时候返回 true，触发移除动作就可以了。关键代码如下：</p>
<pre class="lang-java" data-nodeid="24787"><code data-language="java"><span class="hljs-keyword">public</span> <span class="hljs-class"><span class="hljs-keyword">class</span> <span class="hljs-title">LRU</span> <span class="hljs-keyword">extends</span> <span class="hljs-title">LinkedHashMap</span> </span>{ 
 &nbsp; &nbsp;<span class="hljs-keyword">int</span> capacity; 
 &nbsp; &nbsp;<span class="hljs-function"><span class="hljs-keyword">public</span> <span class="hljs-title">LRU</span><span class="hljs-params">(<span class="hljs-keyword">int</span> capacity)</span> </span>{ 
 &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-keyword">super</span>(<span class="hljs-number">16</span>, <span class="hljs-number">0.75f</span>, <span class="hljs-keyword">true</span>); 
 &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-keyword">this</span>.capacity = capacity; 
 &nbsp;  } 
 &nbsp; &nbsp;<span class="hljs-meta">@Override</span> 
 &nbsp; &nbsp;<span class="hljs-function"><span class="hljs-keyword">protected</span> <span class="hljs-keyword">boolean</span> <span class="hljs-title">removeEldestEntry</span><span class="hljs-params">(Map.Entry eldest)</span> </span>{ 
 &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-keyword">return</span> size() &gt; capacity; 
 &nbsp;  } 
}
</code></pre>
<p data-nodeid="24788">相比较 LC，这段代码实现的功能是比较简陋的，它甚至不是线程安全的，但它体现了缓存设计的一般思路，是 Java 中最简单的 LRU 实现方式。</p>
<h3 data-nodeid="24789">进一步加速</h3>
<p data-nodeid="24790">在 Linux 系统中，通过 free 命令，能够看到系统内存的使用状态。其中，有一块叫作 <strong data-nodeid="25056">cached</strong> 的区域，占用了大量的内存空间。</p>
<p data-nodeid="24791"><img src="https://s0.lgstatic.com/i/image/M00/3C/61/Ciqc1F8nuKqAJaGZAAF4FboRD9E367.png" alt="Drawing 8.png" data-nodeid="25059"></p>
<p data-nodeid="24792">如图所示，这个区域，其实就是存放了操作系统的文件缓存，当应用再次用到它的时候，就不用再到磁盘里走一圈，能够从内存里快速载入。</p>
<p data-nodeid="24793">在文件读取的缓存方面，操作系统做得更多。由于磁盘擅长顺序读写，在随机读写的时候，效率很低，所以，操作系统使用了智能的<strong data-nodeid="25066">预读算法</strong>（readahead），将数据从硬盘中加载到缓存中。</p>
<p data-nodeid="24794">预读算法有三个关键点：</p>
<ul data-nodeid="24795">
<li data-nodeid="24796">
<p data-nodeid="24797"><strong data-nodeid="25072">预测性</strong>，能够根据应用的使用数据，提前预测应用后续的操作目标；</p>
</li>
<li data-nodeid="24798">
<p data-nodeid="24799"><strong data-nodeid="25077">提前</strong>，能够将这些数据提前加载到缓存中，保证命中率；</p>
</li>
<li data-nodeid="24800">
<p data-nodeid="24801"><strong data-nodeid="25082">批量</strong>，将小块的、频繁的读取操作，合并成顺序的批量读取，提高性能。</p>
</li>
</ul>
<p data-nodeid="24802">预读技术一般都是比较智能的，能够覆盖大多数后续的读取操作。举个极端的例子，如果我们的数据集合比较小，访问频率又非常高，就可以使用完全载入的方式，来替换懒加载的方式。在系统启动的时候，将数据加载到缓存中。</p>
<h3 data-nodeid="24803">缓存优化的一般思路</h3>
<p data-nodeid="24804">一般，缓存针对的主要是读操作。<strong data-nodeid="25090">当你的功能遇到下面的场景时</strong>，就可以选择使用缓存组件进行性能优化：</p>
<ul data-nodeid="24805">
<li data-nodeid="24806">
<p data-nodeid="24807">存在数据热点，缓存的数据能够被频繁使用；</p>
</li>
<li data-nodeid="24808">
<p data-nodeid="24809">读操作明显比写操作要多；</p>
</li>
<li data-nodeid="24810">
<p data-nodeid="24811">下游功能存在着比较悬殊的性能差异，下游服务能力有限；</p>
</li>
<li data-nodeid="24812">
<p data-nodeid="24813">加入缓存以后，不会影响程序的正确性，或者引入不可预料的复杂性。</p>
</li>
</ul>
<p data-nodeid="24814">缓存组件和缓冲类似，也是在两个组件速度严重不匹配的时候，引入的一个中间层，但<strong data-nodeid="25099">它们服务的目标是不同的：</strong></p>
<ul data-nodeid="24815">
<li data-nodeid="24816">
<p data-nodeid="24817">缓冲，数据一般只使用一次，等待缓冲区满了，就执行 flush 操作；</p>
</li>
<li data-nodeid="24818">
<p data-nodeid="24819">缓存，数据被载入之后，可以多次使用，数据将会共享多次。</p>
</li>
</ul>
<p data-nodeid="24820"><strong data-nodeid="25106">缓存最重要的指标就是命中率</strong>，有以下几个因素会影响命中率。</p>
<p data-nodeid="24821"><strong data-nodeid="25110">（1）缓存容量</strong></p>
<p data-nodeid="24822">缓存的容量总是有限制的，所以就存在一些冷数据的逐出问题。但缓存也不是越大越好，它不能明显挤占业务的内存。</p>
<p data-nodeid="24823"><strong data-nodeid="25115">（2）数据集类型</strong></p>
<p data-nodeid="24824">如果缓存的数据是非热点数据，或者是操作几次就不再使用的冷数据，那命中率肯定会低，缓存也会失去了它的作用。</p>
<p data-nodeid="24825"><strong data-nodeid="25120">（3）缓存失效策略</strong></p>
<p data-nodeid="24826">缓存算法也会影响命中率和性能，目前效率最高的算法是 Caffeine 使用的 <strong data-nodeid="25126">W-TinyLFU 算法</strong>，它的命中率非常高，内存占用也更小。新版本的 spring-cache，已经默认支持 Caffeine。</p>
<p data-nodeid="24827">下图展示了这个算法的性能，<a href="https://github.com/ben-manes/caffeine" data-nodeid="25130">从官网的 github 仓库</a>就可以找到 JMH 的测试代码。</p>
<p data-nodeid="24828"><img src="https://s0.lgstatic.com/i/image/M00/3C/6C/CgqCHl8nuQWAKsjIAAG1hzHS76Q255.png" alt="Drawing 9.png" data-nodeid="25134"></p>
<p data-nodeid="24829">推荐使用 Guava Cache 或者 Caffeine 作为堆内缓存解决方案，然后通过它们提供的一系列监控指标，来调整缓存的大小和内容，一般来说：</p>
<ul data-nodeid="24830">
<li data-nodeid="24831">
<p data-nodeid="24832">缓存命中率达到 50% 以上，作用就开始变得显著；</p>
</li>
<li data-nodeid="24833">
<p data-nodeid="24834">缓存命中率低于 10%，那就需要考虑缓存组件的必要性了。</p>
</li>
</ul>
<p data-nodeid="24835">引入缓存组件，能够显著提升系统性能，但也会引入新的问题。其中，最典型的也是面试高频问题：如何保证缓存与源数据的同步？关于这点，我们会在下一课时进行讲解。</p>
<h3 data-nodeid="24836">小结</h3>
<p data-nodeid="24837">最后，我来总结一下本课时的知识要点。</p>
<p data-nodeid="24838">我们先以 Guava 的 LoadingCache 为例，讲解了堆内缓存设计的一些思路；同时，介绍了一个因为缓存不合理利用所造成的内存故障，这些都是面试中的高频问题；然后又讲解了，三个常用的缓存算法 LRU、LFU、FIFO，并以 LinkedHashMap 为基础，实现了一个最简单的 LRU 缓存。</p>
<p data-nodeid="24839">本课时还提到了使用预读或者提前载入等方式，来进一步加速应用的方法，readahead技术，在操作系统、数据库中使用非常多，性能提升也比较显著。</p>
<p data-nodeid="24840">最后，我们提到可以通过利用缓存框架的一些监控数据，来调整缓存的命中率，要达到50% 的命中率才算有较好的效果。</p>
<p data-nodeid="24841">接下来，我再简单举两个<strong data-nodeid="25149">缓存应用</strong>的例子。</p>
<ul data-nodeid="26074">
<li data-nodeid="26075">
<p data-nodeid="26076">第一个是 HTTP 304 状态码，它是 Not Modified 的意思。<br>
浏览器客户端会发送一个条件性的请求，服务端可以通过 If-Modified-Since 头信息判断缓冲的文件是否是最新的。如果是，那么客户端就直接使用缓存，不用进行再读取了。</p>
</li>
<li data-nodeid="26077">
<p data-nodeid="26078" class="">另一个是关于 CDN，这是一种变相的缓存。<br>
用户会从离它最近最快的节点，读取文件内容。如果这个节点没有缓存这个文件，那么 CDN 节点就会从源站拉取一份，下次有相同的读取请求时，就可以快速返回。</p>
</li>
</ul>


<p data-nodeid="24847" class="">缓存的应用非常广泛，大家在平常的工作中，也可以尝试进行总结、类比。</p>

---

### 精选评论

##### **伟：
> 你好，我想请问一下，因为我不是做开发的，所以问的小白问题，之前一直以为redis 就是缓存，看了一门课程才知道错了，所以缓存跟redis 有关系吗？

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; redis最主要的作用就是分布式缓存，但由于它的数据结构类型很多，所以它的应用场景很广泛：比如，分布式锁、排行榜、限流等。

##### **6114：
> 还可以专题比较一下，本地缓存和远程缓存；原来做过一个项目，虽然用到了Redis缓存，但是速度还是慢；后来进行各步骤时间统计，发现取远端缓存的时间，占用了整个处理时间的将近一半（需要使用的缓存数据较多，从Redis取了好几次），后来改成了本地缓存，解决了问题。当然，使用了本地缓存，也引入了其他问题，譬如主要一个就是：缓存数据更新的问题；不过都在业务允许的范围内解决了；

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 缓存是高并发下最重要的优化组件，使用的时候确实需要仔细设计。Redis（6.x）最新版已经把数据传输这部分改成多线程了，一定程度上会解决因为数据量过大引起的传输问题。

##### **辉：
> 老师，引入缓存后，数据一致性的问题是怎么考量的呢？

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 一致性在08，下一小节有讨论

##### **君：
> 老师，您课程里架构图是用什么工具画的

 ###### &nbsp;&nbsp;&nbsp; 编辑回复：
> &nbsp;&nbsp;&nbsp; 同学你在APP上看到的图是我们后期同学制作的，
老师的原图是用 OmniGraffle 做的（不过只有mac版本有）

##### **温：
> 赞，学到很多

##### **炯：
> 如何解决第一次慢的问题

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 缓存一般都是懒加载触发，加载动作比较分散，单次加载缓慢并没有什么问题。如果你缓存的数据不多，可以采用预加载的方式，在应用启动时把数据全部加载到内存里。

